<?php

namespace App\Form;

use App\Entity\PortfolioMedia;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use App\Entity\PortfolioData;

class PortfolioMediaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', null, [
                'label'     => 'Nom'
            ])
            ->add('portfolioData', EntityType::class, [
                'class'     => PortfolioData::class, 
                'choice_label' => 'title',
                'required'  => false,
                'label'     => 'Affecter à un article'
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => PortfolioMedia::class,
        ]);
    }
}
