<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Validator\Constraints as Assert;
use App\ResizeImage;

/**
 * @ORM\Entity(repositoryClass="App\Repository\PortfolioMediaRepository")
 */
class PortfolioMedia
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\PortfolioData", inversedBy="medias")
     * @ORM\JoinColumn(nullable=true)
     */
    private $portfolioData;


    /**
     * @ORM\Column(type="string")
     *
     * @Assert\NotBlank(message="Please, upload the media as a image file.")
     */
    private $file;

    public function __construct()
    {
        
    }

    public function getId()
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getPortfolioData(): ?PortfolioData
    {
        return $this->portfolioData;
    }

    public function setPortfolioData(?PortfolioData $portfolioData): self
    {
        $this->portfolioData = $portfolioData;

        return $this;
    }

    public function getFile(?string $size = null): ?File
    {
        // return $this->file;
        if (!is_null($this->file)) {
            switch ($size) {
                case 'sm':
                case 'md':
                case 'lg':
                    $ext = explode('.', $this->file);
                    $ext = $ext[count($ext) - 1];
                    if (is_file('medias/'. str_replace('.' . $ext, '_' . $size . '.' . $ext, $this->file))) {
                        return new File('medias/'. str_replace('.' . $ext, '_' . $size . '.' . $ext, $this->file));
                    } else {
                        return new File('medias/'.$this->file);
                    }
                    break;
                
                default:
                    return new File('medias/'.$this->file);
                    break;
            }
        } else {
            return null;
        }
    }

    public function setFile(File $file): self
    {
        $rootDir = __DIR__.'/../../';
        $uploadDir = $rootDir.'public/medias/';

        // compute a random name and try to guess the extension (more secure)
        $extension = $file->guessExtension();
        if (!$extension) {
            // extension cannot be guessed
            $extension = 'jpg';
        }

        $fileName = md5(uniqid());
        $fileName_ext = $fileName.'.'.$extension;

        $file->move($uploadDir, $fileName_ext);

        $image = new ResizeImage($uploadDir . $fileName_ext);
        $image->resizeTo(1920, 1080);
        $image->saveImage($uploadDir . $fileName . '_lg.' . $extension);
        $image->resizeTo(600, 600);
        $image->saveImage($uploadDir . $fileName . '_md.' . $extension);
        $image->resizeTo(300, 300);
        $image->saveImage($uploadDir . $fileName . '_sm.' . $extension);

        $this->file = $fileName_ext;

        return $this;
    }
}
