<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\PortfolioCategoryRepository")
 */
class PortfolioCategory
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\PortfolioData", mappedBy="category")
     */
    private $portfolioData;

    public function __construct()
    {
        $this->portfolioData = new ArrayCollection();
    }

    public function getId()
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|PortfolioData[]
     */
    public function getPortfolioData(): Collection
    {
        return $this->portfolioData;
    }

    public function addPortfolioData(PortfolioData $portfolioData): self
    {
        if (!$this->portfolioData->contains($portfolioData)) {
            $this->portfolioData[] = $portfolioData;
            $portfolioData->setCategory($this);
        }

        return $this;
    }

    public function removePortfolioData(PortfolioData $portfolioData): self
    {
        if ($this->portfolioData->contains($portfolioData)) {
            $this->portfolioData->removeElement($portfolioData);
            // set the owning side to null (unless already changed)
            if ($portfolioData->getCategory() === $this) {
                $portfolioData->setCategory(null);
            }
        }

        return $this;
    }
}
