<?php

namespace App\Controller;

use App\Entity\PortfolioMedia;
use App\Form\PortfolioMediaType;
use App\Repository\PortfolioMediaRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Form\Extension\Core\Type\FileType;

/**
 * @Route("/admin/medias")
 */
class PortfolioMediaController extends AbstractController
{
    /**
     * @Route("/", name="portfolio_media_index", methods="GET")
     */
    public function index(PortfolioMediaRepository $portfolioMediaRepository): Response
    {
        return $this->render('admin/portfolio_media/index.html.twig', ['portfolio_media' => $portfolioMediaRepository->findAll()]);
    }

    /**
     * @Route("/new", name="portfolio_media_new", methods="GET|POST")
     */
    public function new(Request $request): Response
    {
        $portfolioMedia = new PortfolioMedia();
        $form = $this->createForm(PortfolioMediaType::class, $portfolioMedia)
            ->add('file', FileType::class, [
                'label' => 'Fichier'
            ]);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($portfolioMedia);
            $em->flush();

            return $this->redirectToRoute('portfolio_media_index');
        }

        return $this->render('admin/portfolio_media/new.html.twig', [
            'portfolio_media' => $portfolioMedia,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{id}", name="portfolio_media_show", methods="GET")
     */
    public function show(PortfolioMedia $portfolioMedia): Response
    {
        return $this->render('admin/portfolio_media/show.html.twig', ['portfolio_media' => $portfolioMedia]);
    }

    /**
     * @Route("/{id}/edit", name="portfolio_media_edit", methods="GET|POST")
     */
    public function edit(Request $request, PortfolioMedia $portfolioMedia): Response
    {
        $form = $this->createForm(PortfolioMediaType::class, $portfolioMedia);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('portfolio_media_edit', ['id' => $portfolioMedia->getId()]);
        }

        return $this->render('admin/portfolio_media/edit.html.twig', [
            'portfolio_media' => $portfolioMedia,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{id}", name="portfolio_media_delete", methods="DELETE")
     */
    public function delete(Request $request, PortfolioMedia $portfolioMedia): Response
    {
        if ($this->isCsrfTokenValid('delete'.$portfolioMedia->getId(), $request->request->get('_token'))) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($portfolioMedia);
            $em->flush();
        }

        return $this->redirectToRoute('portfolio_media_index');
    }
}
