<?php

namespace App\Controller;

use App\Entity\PortfolioData;
use App\Form\PortfolioDataType;
use App\Repository\PortfolioDataRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/admin/datas")
 */
class PortfolioDataController extends AbstractController
{
    /**
     * @Route("/", name="portfolio_data_index", methods="GET")
     */
    public function index(PortfolioDataRepository $portfolioDataRepository): Response
    {
        return $this->render('admin/portfolio_data/index.html.twig', ['portfolio_datas' => $portfolioDataRepository->findAll()]);
    }

    /**
     * @Route("/new", name="portfolio_data_new", methods="GET|POST")
     */
    public function new(Request $request): Response
    {
        $portfolioDatum = new PortfolioData();
        $form = $this->createForm(PortfolioDataType::class, $portfolioDatum);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($portfolioDatum);
            $em->flush();

            return $this->redirectToRoute('portfolio_data_index');
        }

        return $this->render('admin/portfolio_data/new.html.twig', [
            'portfolio_datum' => $portfolioDatum,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{id}", name="portfolio_data_show", methods="GET")
     */
    public function show(PortfolioData $portfolioDatum): Response
    {
        return $this->render('admin/portfolio_data/show.html.twig', ['portfolio_datum' => $portfolioDatum]);
    }

    /**
     * @Route("/{id}/edit", name="portfolio_data_edit", methods="GET|POST")
     */
    public function edit(Request $request, PortfolioData $portfolioDatum): Response
    {
        $form = $this->createForm(PortfolioDataType::class, $portfolioDatum);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('portfolio_data_edit', ['id' => $portfolioDatum->getId()]);
        }

        return $this->render('admin/portfolio_data/edit.html.twig', [
            'portfolio_datum' => $portfolioDatum,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{id}", name="portfolio_data_delete", methods="DELETE")
     */
    public function delete(Request $request, PortfolioData $portfolioDatum): Response
    {
        if ($this->isCsrfTokenValid('delete'.$portfolioDatum->getId(), $request->request->get('_token'))) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($portfolioDatum);
            $em->flush();
        }

        return $this->redirectToRoute('portfolio_data_index');
    }
}
