<?php

namespace App\Controller;

use App\Entity\PortfolioCategory;
use App\Form\PortfolioCategoryType;
use App\Repository\PortfolioCategoryRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/admin/categories")
 */
class PortfolioCategoryController extends AbstractController
{
    /**
     * @Route("/", name="portfolio_category_index", methods="GET")
     */
    public function index(PortfolioCategoryRepository $portfolioCategoryRepository): Response
    {
        return $this->render('admin/portfolio_category/index.html.twig', ['portfolio_categories' => $portfolioCategoryRepository->findAll()]);
    }

    /**
     * @Route("/new", name="portfolio_category_new", methods="GET|POST")
     */
    public function new(Request $request): Response
    {
        $portfolioCategory = new PortfolioCategory();
        $form = $this->createForm(PortfolioCategoryType::class, $portfolioCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($portfolioCategory);
            $em->flush();

            return $this->redirectToRoute('portfolio_category_index');
        }

        return $this->render('admin/portfolio_category/new.html.twig', [
            'portfolio_category' => $portfolioCategory,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{id}", name="portfolio_category_show", methods="GET")
     */
    public function show(PortfolioCategory $portfolioCategory): Response
    {
        return $this->render('admin/portfolio_category/show.html.twig', ['portfolio_category' => $portfolioCategory]);
    }

    /**
     * @Route("/{id}/edit", name="portfolio_category_edit", methods="GET|POST")
     */
    public function edit(Request $request, PortfolioCategory $portfolioCategory): Response
    {
        $form = $this->createForm(PortfolioCategoryType::class, $portfolioCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('portfolio_category_edit', ['id' => $portfolioCategory->getId()]);
        }

        return $this->render('admin/portfolio_category/edit.html.twig', [
            'portfolio_category' => $portfolioCategory,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{id}", name="portfolio_category_delete", methods="DELETE")
     */
    public function delete(Request $request, PortfolioCategory $portfolioCategory): Response
    {
        if ($this->isCsrfTokenValid('delete'.$portfolioCategory->getId(), $request->request->get('_token'))) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($portfolioCategory);
            $em->flush();
        }

        return $this->redirectToRoute('portfolio_category_index');
    }
}
