<?php

namespace App\Controller;

use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use App\Entity\PortfolioCategory;
use App\Entity\PortfolioData;
// use App\Repository\PortfolioDataRepository as Repository;

class HomeController extends AbstractController
{
    /**
     * @Route("/", name="home", methods="GET")
     */
    public function index()
    {
        //if (getenv('APP_ENV') == 'dev') {
            $datas = $this->getDoctrine()->getRepository(PortfolioCategory::class)->findAll();
            return $this->render('home/index.html.twig', [
                'datas'         => $datas,
            ]);
        /*} else {
            return $this->render('home/construction.html.twig');
        }*/
    }

    /**
     * @Route("/article/{id}", name="single_article", methods="GET", requirements={"id"="\d+"})
     */
    public function article($id = null)
    {
        $article = $this->getDoctrine()->getRepository(PortfolioData::class)->find($id);
        return $this->render('home/article.html.twig', [
            'article'       => $article,
        ]);
    }

    /**
     * @Route("/admin", name="admin", methods="GET")
     */
    public function admin()
    {
        return $this->render('admin/admin.html.twig', [

        ]);
    }

    /**
     * @Route("/test", name="test", methods="GET")
     */
    public function test()
    {
        return $this->render('home/test.html.twig', [

        ]);
    }
}
